/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.render.box;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1087;
import net.minecraft.class_1161;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_296;
import net.minecraft.class_4587;
import net.minecraft.class_777;
import team.creative.creativecore.client.render.face.FaceRenderType;
import team.creative.creativecore.client.render.face.IFaceRenderType;
import team.creative.creativecore.common.mod.OptifineHelper;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.box.AlignedBox;
import team.creative.creativecore.common.util.math.geo.NormalPlane;
import team.creative.creativecore.common.util.math.geo.Ray2d;
import team.creative.creativecore.common.util.math.geo.VectorFan;
import team.creative.creativecore.common.util.math.vec.Vec3f;
import team.creative.creativecore.common.util.mc.ColorUtils;
import team.creative.creativecore.mixin.VertexFormatAccessor;

@Environment(value=EnvType.CLIENT)
public class RenderBox
extends AlignedBox {
    private static final VectorFan DOWN = new VectorFanSimple(new Vec3f[]{new Vec3f(0.0f, 0.0f, 1.0f), new Vec3f(0.0f, 0.0f, 0.0f), new Vec3f(1.0f, 0.0f, 0.0f), new Vec3f(1.0f, 0.0f, 1.0f)});
    private static final VectorFan UP = new VectorFanSimple(new Vec3f[]{new Vec3f(0.0f, 1.0f, 0.0f), new Vec3f(0.0f, 1.0f, 1.0f), new Vec3f(1.0f, 1.0f, 1.0f), new Vec3f(1.0f, 1.0f, 0.0f)});
    private static final VectorFan NORTH = new VectorFanSimple(new Vec3f[]{new Vec3f(1.0f, 1.0f, 0.0f), new Vec3f(1.0f, 0.0f, 0.0f), new Vec3f(0.0f, 0.0f, 0.0f), new Vec3f(0.0f, 1.0f, 0.0f)});
    private static final VectorFan SOUTH = new VectorFanSimple(new Vec3f[]{new Vec3f(0.0f, 1.0f, 1.0f), new Vec3f(0.0f, 0.0f, 1.0f), new Vec3f(1.0f, 0.0f, 1.0f), new Vec3f(1.0f, 1.0f, 1.0f)});
    private static final VectorFan WEST = new VectorFanSimple(new Vec3f[]{new Vec3f(0.0f, 1.0f, 0.0f), new Vec3f(0.0f, 0.0f, 0.0f), new Vec3f(0.0f, 0.0f, 1.0f), new Vec3f(0.0f, 1.0f, 1.0f)});
    private static final VectorFan EAST = new VectorFanSimple(new Vec3f[]{new Vec3f(1.0f, 1.0f, 1.0f), new Vec3f(1.0f, 0.0f, 1.0f), new Vec3f(1.0f, 0.0f, 0.0f), new Vec3f(1.0f, 1.0f, 0.0f)});
    public class_2680 state;
    public int color = -1;
    public boolean keepVU = false;
    public boolean allowOverlap = false;
    public boolean doesNeedQuadUpdate = true;
    public boolean needsResorting = false;
    public boolean emissive = false;
    public Object customData;
    private IFaceRenderType renderEast = FaceRenderType.INSIDE_RENDERED;
    private IFaceRenderType renderWest = FaceRenderType.INSIDE_RENDERED;
    private IFaceRenderType renderUp = FaceRenderType.INSIDE_RENDERED;
    private IFaceRenderType renderDown = FaceRenderType.INSIDE_RENDERED;
    private IFaceRenderType renderSouth = FaceRenderType.INSIDE_RENDERED;
    private IFaceRenderType renderNorth = FaceRenderType.INSIDE_RENDERED;
    private Object quadEast = null;
    private Object quadWest = null;
    private Object quadUp = null;
    private Object quadDown = null;
    private Object quadSouth = null;
    private Object quadNorth = null;

    public RenderBox(AlignedBox cube) {
        super(cube);
    }

    public RenderBox(AlignedBox cube, RenderBox box) {
        super(cube);
        this.state = box.state;
        this.color = box.color;
        this.renderEast = box.renderEast;
        this.renderWest = box.renderWest;
        this.renderUp = box.renderUp;
        this.renderDown = box.renderDown;
        this.renderSouth = box.renderSouth;
        this.renderNorth = box.renderNorth;
    }

    public RenderBox(AlignedBox cube, class_2680 state) {
        super(cube);
        this.state = state;
    }

    public RenderBox(AlignedBox cube, class_2248 block) {
        this(cube, block.method_9564());
    }

    public RenderBox(float minX, float minY, float minZ, float maxX, float maxY, float maxZ, class_2680 state) {
        super(minX, minY, minZ, maxX, maxY, maxZ);
        this.state = state;
    }

    public RenderBox(float minX, float minY, float minZ, float maxX, float maxY, float maxZ, class_2248 block) {
        this(minX, minY, minZ, maxX, maxY, maxZ, block.method_9564());
    }

    private static int uvOffset(class_293 format) {
        for (int i = 0; i < format.method_1357().size(); ++i) {
            if (((class_296)format.method_1357().get(i)).method_1382() != class_296.class_298.field_1636) continue;
            return ((VertexFormatAccessor)format).getOffsets().getInt(i);
        }
        return -1;
    }

    public RenderBox setColor(int color) {
        this.color = color;
        return this;
    }

    public RenderBox setKeepUV(boolean keep) {
        this.keepVU = keep;
        return this;
    }

    public void setQuad(Facing facing, List<class_777> quads) {
        class_777 quad = quads == null || quads.isEmpty() ? null : (quads.size() == 1 ? quads.get(0) : quads);
        switch (facing) {
            case DOWN: {
                this.quadDown = quad;
                break;
            }
            case EAST: {
                this.quadEast = quad;
                break;
            }
            case NORTH: {
                this.quadNorth = quad;
                break;
            }
            case SOUTH: {
                this.quadSouth = quad;
                break;
            }
            case UP: {
                this.quadUp = quad;
                break;
            }
            case WEST: {
                this.quadWest = quad;
            }
        }
    }

    public Object getQuad(Facing facing) {
        return switch (facing) {
            default -> throw new IncompatibleClassChangeError();
            case Facing.DOWN -> this.quadDown;
            case Facing.EAST -> this.quadEast;
            case Facing.NORTH -> this.quadNorth;
            case Facing.SOUTH -> this.quadSouth;
            case Facing.UP -> this.quadUp;
            case Facing.WEST -> this.quadWest;
        };
    }

    public int countQuads() {
        int quads = 0;
        if (this.quadUp != null) {
            quads += this.quadUp instanceof List ? ((List)this.quadUp).size() : 1;
        }
        if (this.quadDown != null) {
            quads += this.quadDown instanceof List ? ((List)this.quadDown).size() : 1;
        }
        if (this.quadEast != null) {
            quads += this.quadEast instanceof List ? ((List)this.quadEast).size() : 1;
        }
        if (this.quadWest != null) {
            quads += this.quadWest instanceof List ? ((List)this.quadWest).size() : 1;
        }
        if (this.quadSouth != null) {
            quads += this.quadSouth instanceof List ? ((List)this.quadSouth).size() : 1;
        }
        if (this.quadNorth != null) {
            quads += this.quadNorth instanceof List ? ((List)this.quadNorth).size() : 1;
        }
        return quads;
    }

    public void setType(Facing facing, IFaceRenderType renderer) {
        switch (facing) {
            case DOWN: {
                this.renderDown = renderer;
                break;
            }
            case EAST: {
                this.renderEast = renderer;
                break;
            }
            case NORTH: {
                this.renderNorth = renderer;
                break;
            }
            case SOUTH: {
                this.renderSouth = renderer;
                break;
            }
            case UP: {
                this.renderUp = renderer;
                break;
            }
            case WEST: {
                this.renderWest = renderer;
            }
        }
    }

    public IFaceRenderType getType(Facing facing) {
        return switch (facing) {
            default -> throw new IncompatibleClassChangeError();
            case Facing.DOWN -> this.renderDown;
            case Facing.EAST -> this.renderEast;
            case Facing.NORTH -> this.renderNorth;
            case Facing.SOUTH -> this.renderSouth;
            case Facing.UP -> this.renderUp;
            case Facing.WEST -> this.renderWest;
        };
    }

    public boolean renderSide(Facing facing) {
        return switch (facing) {
            default -> throw new IncompatibleClassChangeError();
            case Facing.DOWN -> this.renderDown.shouldRender();
            case Facing.EAST -> this.renderEast.shouldRender();
            case Facing.NORTH -> this.renderNorth.shouldRender();
            case Facing.SOUTH -> this.renderSouth.shouldRender();
            case Facing.UP -> this.renderUp.shouldRender();
            case Facing.WEST -> this.renderWest.shouldRender();
        };
    }

    public boolean intersectsWithFace(Facing facing, RenderInformationHolder holder, class_2338 offset) {
        return switch (facing.axis) {
            default -> throw new IncompatibleClassChangeError();
            case Axis.X -> {
                if (holder.maxY > this.minY - (float)offset.method_10264() && holder.minY < this.maxY - (float)offset.method_10264() && holder.maxZ > this.minZ - (float)offset.method_10260() && holder.minZ < this.maxZ - (float)offset.method_10260()) {
                    yield true;
                }
                yield false;
            }
            case Axis.Y -> {
                if (holder.maxX > this.minX - (float)offset.method_10263() && holder.minX < this.maxX - (float)offset.method_10263() && holder.maxZ > this.minZ - (float)offset.method_10260() && holder.minZ < this.maxZ - (float)offset.method_10260()) {
                    yield true;
                }
                yield false;
            }
            case Axis.Z -> holder.maxX > this.minX - (float)offset.method_10263() && holder.minX < this.maxX - (float)offset.method_10263() && holder.maxY > this.minY - (float)offset.method_10264() && holder.minY < this.maxY - (float)offset.method_10264();
        };
    }

    protected Object getRenderQuads(Facing facing) {
        if (this.getType(facing).hasCachedFans()) {
            return this.getType(facing).getCachedFans();
        }
        return switch (facing) {
            default -> throw new IncompatibleClassChangeError();
            case Facing.DOWN -> DOWN;
            case Facing.EAST -> EAST;
            case Facing.NORTH -> NORTH;
            case Facing.SOUTH -> SOUTH;
            case Facing.UP -> UP;
            case Facing.WEST -> WEST;
        };
    }

    protected float getOffsetX() {
        return this.minX;
    }

    protected float getOffsetY() {
        return this.minY;
    }

    protected float getOffsetZ() {
        return this.minZ;
    }

    protected float getOverallScale(Facing facing) {
        return this.getType(facing).getScale();
    }

    protected float getScaleX() {
        return this.maxX - this.minX;
    }

    protected float getScaleY() {
        return this.maxY - this.minY;
    }

    protected float getScaleZ() {
        return this.maxZ - this.minZ;
    }

    protected boolean scaleAndOffsetQuads(Facing facing) {
        return true;
    }

    protected boolean onlyScaleOnceNoOffset(Facing facing) {
        return this.getType(facing).hasCachedFans();
    }

    public void deleteQuadCache() {
        this.doesNeedQuadUpdate = true;
        this.quadEast = null;
        this.quadWest = null;
        this.quadUp = null;
        this.quadDown = null;
        this.quadSouth = null;
        this.quadNorth = null;
    }

    protected boolean previewScalingAndOffset() {
        return true;
    }

    public float getPreviewOffX() {
        return this.minX;
    }

    public float getPreviewOffY() {
        return this.minY;
    }

    public float getPreviewOffZ() {
        return this.minZ;
    }

    public float getPreviewScaleX() {
        return this.maxX - this.minX;
    }

    public float getPreviewScaleY() {
        return this.maxY - this.minY;
    }

    public float getPreviewScaleZ() {
        return this.maxZ - this.minZ;
    }

    public void renderPreview(class_4587 pose, class_287 builder, int alpha) {
        int red = ColorUtils.red(this.color);
        int green = ColorUtils.green(this.color);
        int blue = ColorUtils.blue(this.color);
        if (this.previewScalingAndOffset()) {
            for (int i = 0; i < Facing.values().length; ++i) {
                Object renderQuads = this.getRenderQuads(Facing.values()[i]);
                if (renderQuads instanceof List) {
                    for (int j = 0; j < ((List)renderQuads).size(); ++j) {
                        ((VectorFan)((List)renderQuads).get(j)).renderPreview(pose.method_23760().method_23761(), builder, this.getPreviewOffX(), this.getPreviewOffY(), this.getPreviewOffZ(), this.getPreviewScaleX(), this.getPreviewScaleY(), this.getPreviewScaleZ(), red, green, blue, alpha);
                    }
                    continue;
                }
                if (!(renderQuads instanceof VectorFan)) continue;
                ((VectorFan)renderQuads).renderPreview(pose.method_23760().method_23761(), builder, this.getPreviewOffX(), this.getPreviewOffY(), this.getPreviewOffZ(), this.getPreviewScaleX(), this.getPreviewScaleY(), this.getPreviewScaleZ(), red, green, blue, alpha);
            }
        } else {
            for (int i = 0; i < Facing.values().length; ++i) {
                Object renderQuads = this.getRenderQuads(Facing.values()[i]);
                if (renderQuads instanceof List) {
                    for (int j = 0; j < ((List)renderQuads).size(); ++j) {
                        ((VectorFan)((List)renderQuads).get(j)).renderPreview(pose.method_23760().method_23761(), builder, red, green, blue, alpha);
                    }
                    continue;
                }
                if (!(renderQuads instanceof VectorFan)) continue;
                ((VectorFan)renderQuads).renderPreview(pose.method_23760().method_23761(), builder, red, green, blue, alpha);
            }
        }
    }

    public void renderLines(class_4587 pose, class_287 builder, int alpha) {
        int red = ColorUtils.red(this.color);
        int green = ColorUtils.green(this.color);
        int blue = ColorUtils.blue(this.color);
        if (red == 1 && green == 1 && blue == 1) {
            blue = 0;
            green = 0;
            red = 0;
        }
        if (this.previewScalingAndOffset()) {
            for (int i = 0; i < Facing.values().length; ++i) {
                Object renderQuads = this.getRenderQuads(Facing.values()[i]);
                if (renderQuads instanceof List) {
                    for (int j = 0; j < ((List)renderQuads).size(); ++j) {
                        ((VectorFan)((List)renderQuads).get(j)).renderLines(pose.method_23760().method_23761(), builder, this.getPreviewOffX(), this.getPreviewOffY(), this.getPreviewOffZ(), this.getPreviewScaleX(), this.getPreviewScaleY(), this.getPreviewScaleZ(), red, green, blue, alpha);
                    }
                    continue;
                }
                if (!(renderQuads instanceof VectorFan)) continue;
                ((VectorFan)renderQuads).renderLines(pose.method_23760().method_23761(), builder, this.getPreviewOffX(), this.getPreviewOffY(), this.getPreviewOffZ(), this.getPreviewScaleX(), this.getPreviewScaleY(), this.getPreviewScaleZ(), red, green, blue, alpha);
            }
        } else {
            for (int i = 0; i < Facing.values().length; ++i) {
                Object renderQuads = this.getRenderQuads(Facing.values()[i]);
                if (renderQuads instanceof List) {
                    for (int j = 0; j < ((List)renderQuads).size(); ++j) {
                        ((VectorFan)((List)renderQuads).get(j)).renderLines(pose.method_23760().method_23761(), builder, red, green, blue, alpha);
                    }
                    continue;
                }
                if (!(renderQuads instanceof VectorFan)) continue;
                ((VectorFan)renderQuads).renderLines(pose.method_23760().method_23761(), builder, red, green, blue, alpha);
            }
        }
    }

    public void renderLines(class_4587 pose, class_287 builder, int alpha, class_1161 center, double grow) {
        int red = ColorUtils.red(this.color);
        int green = ColorUtils.green(this.color);
        int blue = ColorUtils.blue(this.color);
        if (red == 1 && green == 1 && blue == 1) {
            blue = 0;
            green = 0;
            red = 0;
        }
        if (this.previewScalingAndOffset()) {
            for (int i = 0; i < Facing.values().length; ++i) {
                Object renderQuads = this.getRenderQuads(Facing.values()[i]);
                if (renderQuads instanceof List) {
                    for (int j = 0; j < ((List)renderQuads).size(); ++j) {
                        ((VectorFan)((List)renderQuads).get(j)).renderLines(pose.method_23760().method_23761(), builder, this.getPreviewOffX(), this.getPreviewOffY(), this.getPreviewOffZ(), this.getPreviewScaleX(), this.getPreviewScaleY(), this.getPreviewScaleZ(), red, green, blue, alpha, center, grow);
                    }
                    continue;
                }
                if (!(renderQuads instanceof VectorFan)) continue;
                ((VectorFan)renderQuads).renderLines(pose.method_23760().method_23761(), builder, this.getPreviewOffX(), this.getPreviewOffY(), this.getPreviewOffZ(), this.getPreviewScaleX(), this.getPreviewScaleY(), this.getPreviewScaleZ(), red, green, blue, alpha, center, grow);
            }
        } else {
            for (int i = 0; i < Facing.values().length; ++i) {
                Object renderQuads = this.getRenderQuads(Facing.values()[i]);
                if (renderQuads instanceof List) {
                    for (int j = 0; j < ((List)renderQuads).size(); ++j) {
                        ((VectorFan)((List)renderQuads).get(j)).renderLines(pose.method_23760().method_23761(), builder, red, green, blue, alpha, center, grow);
                    }
                    continue;
                }
                if (!(renderQuads instanceof VectorFan)) continue;
                ((VectorFan)renderQuads).renderLines(pose.method_23760().method_23761(), builder, red, green, blue, alpha, center, grow);
            }
        }
    }

    public boolean isTranslucent() {
        if (ColorUtils.isTransparent(this.color)) {
            return true;
        }
        return !this.state.method_26207().method_15804() || !this.state.method_26207().method_15799();
    }

    protected List<class_777> getBakedQuad(class_1936 level, class_1087 blockModel, class_2680 state, Facing facing, class_2338 pos, Random rand) {
        return OptifineHelper.getBakedQuad(blockModel.method_4707(state, facing.toVanilla(), rand), level, state, facing, pos, rand);
    }

    public List<class_777> getBakedQuad(class_1936 level, @Nullable class_2338 pos, class_2338 offset, class_2680 state, class_1087 blockModel, Facing facing, Random rand, boolean overrideTint, int defaultColor) {
        List<class_777> blockQuads = this.getBakedQuad(level, blockModel, state, facing, pos, rand);
        if (blockQuads.isEmpty()) {
            return Collections.emptyList();
        }
        RenderInformationHolder holder = new RenderInformationHolder(class_290.field_1590, facing, this.color != -1 ? this.color : defaultColor);
        holder.offset = offset;
        ArrayList<class_777> quads = new ArrayList<class_777>();
        for (class_777 blockQuad : blockQuads) {
            holder.setQuad(blockQuad, overrideTint, defaultColor);
            if (!this.needsResorting && OptifineHelper.isEmissive(holder.quad.method_35788())) {
                this.needsResorting = true;
            }
            int[] data = holder.quad.method_3357();
            int index = 0;
            int uvIndex = index + holder.uvOffset / 4;
            float tempMinX = Float.intBitsToFloat(data[index]);
            float tempMinY = Float.intBitsToFloat(data[index + 1]);
            float tempMinZ = Float.intBitsToFloat(data[index + 2]);
            float tempU = Float.intBitsToFloat(data[uvIndex]);
            holder.uvInverted = false;
            index = 1 * holder.format.method_1359();
            uvIndex = index + holder.uvOffset / 4;
            holder.uvInverted = tempMinX != Float.intBitsToFloat(data[index]) ? (tempU != Float.intBitsToFloat(data[uvIndex]) ? Axis.X != facing.getUAxis() : Axis.X != facing.getVAxis()) : (tempMinY != Float.intBitsToFloat(data[index + 1]) ? (tempU != Float.intBitsToFloat(data[uvIndex]) ? Axis.Y != facing.getUAxis() : Axis.Y != facing.getVAxis()) : (tempU != Float.intBitsToFloat(data[uvIndex]) ? Axis.Z != facing.getUAxis() : Axis.Z != facing.getVAxis()));
            index = 2 * holder.format.method_1359();
            float tempMaxX = Float.intBitsToFloat(data[index]);
            float tempMaxY = Float.intBitsToFloat(data[index + 1]);
            float tempMaxZ = Float.intBitsToFloat(data[index + 2]);
            holder.setBounds(tempMinX, tempMinY, tempMinZ, tempMaxX, tempMaxY, tempMaxZ);
            if (!this.intersectsWithFace(facing, holder, offset)) continue;
            uvIndex = holder.uvOffset / 4;
            float u1 = Float.intBitsToFloat(data[uvIndex]);
            float v1 = Float.intBitsToFloat(data[uvIndex + 1]);
            uvIndex = 2 * holder.format.method_1359() + holder.uvOffset / 4;
            float u2 = Float.intBitsToFloat(data[uvIndex]);
            float v2 = Float.intBitsToFloat(data[uvIndex + 1]);
            if (holder.uvInverted) {
                holder.sizeU = facing.getV(tempMinX, tempMinY, tempMinZ) < facing.getV(tempMaxX, tempMaxY, tempMaxZ) ? u2 - u1 : u1 - u2;
                holder.sizeV = facing.getU(tempMinX, tempMinY, tempMinZ) < facing.getU(tempMaxX, tempMaxY, tempMaxZ) ? v2 - v1 : v1 - v2;
            } else {
                holder.sizeU = facing.getU(tempMinX, tempMinY, tempMinZ) < facing.getU(tempMaxX, tempMaxY, tempMaxZ) ? u2 - u1 : u1 - u2;
                holder.sizeV = facing.getV(tempMinX, tempMinY, tempMinZ) < facing.getV(tempMaxX, tempMaxY, tempMaxZ) ? v2 - v1 : v1 - v2;
            }
            Object renderQuads = this.getRenderQuads(holder.facing);
            if (renderQuads instanceof List) {
                for (int j = 0; j < ((List)renderQuads).size(); ++j) {
                    ((VectorFan)((List)renderQuads).get(j)).generate(holder, quads);
                }
                continue;
            }
            if (!(renderQuads instanceof VectorFan)) continue;
            ((VectorFan)renderQuads).generate(holder, quads);
        }
        return quads;
    }

    public class RenderInformationHolder {
        public final Facing facing;
        public final int color;
        public final class_293 format;
        public final int uvOffset;
        public final boolean scaleAndOffset;
        public final float offsetX;
        public final float offsetY;
        public final float offsetZ;
        public final float scaleX;
        public final float scaleY;
        public final float scaleZ;
        public class_2338 offset;
        public boolean shouldOverrideColor;
        public class_777 quad;
        public NormalPlane normal;
        public Ray2d ray = new Ray2d(Axis.X, Axis.Y, 0.0, 0.0, 0.0, 0.0);
        public float minX;
        public float minY;
        public float minZ;
        public float maxX;
        public float maxY;
        public float maxZ;
        public float sizeX;
        public float sizeY;
        public float sizeZ;
        public boolean uvInverted;
        public float sizeU;
        public float sizeV;

        public RenderInformationHolder(class_293 format, Facing facing, int color) {
            this.color = color;
            this.format = format;
            this.facing = facing;
            this.uvOffset = RenderBox.uvOffset(format);
            RenderBox box = this.getBox();
            this.scaleAndOffset = box.scaleAndOffsetQuads(facing);
            if (this.scaleAndOffset) {
                if (box.onlyScaleOnceNoOffset(facing)) {
                    this.offsetZ = 0.0f;
                    this.offsetY = 0.0f;
                    this.offsetX = 0.0f;
                    this.scaleY = this.scaleZ = box.getOverallScale(facing);
                    this.scaleX = this.scaleZ;
                } else {
                    this.offsetX = box.getOffsetX();
                    this.offsetY = box.getOffsetY();
                    this.offsetZ = box.getOffsetZ();
                    this.scaleX = box.getScaleX();
                    this.scaleY = box.getScaleY();
                    this.scaleZ = box.getScaleZ();
                }
            } else {
                this.offsetZ = 0.0f;
                this.offsetY = 0.0f;
                this.offsetX = 0.0f;
                this.scaleZ = 0.0f;
                this.scaleY = 0.0f;
                this.scaleX = 0.0f;
            }
        }

        public void setQuad(class_777 quad, boolean overrideTint, int defaultColor) {
            this.quad = quad;
            this.shouldOverrideColor = overrideTint && (defaultColor == -1 || quad.method_3360()) && this.color != -1;
        }

        public void setBounds(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
            this.minX = Math.min(minX, maxX);
            this.minY = Math.min(minY, maxY);
            this.minZ = Math.min(minZ, maxZ);
            this.maxX = Math.max(minX, maxX);
            this.maxY = Math.max(minY, maxY);
            this.maxZ = Math.max(minZ, maxZ);
            this.sizeX = this.maxX - this.minX;
            this.sizeY = this.maxY - this.minY;
            this.sizeZ = this.maxZ - this.minZ;
        }

        public RenderBox getBox() {
            return RenderBox.this;
        }

        public boolean hasBounds() {
            return switch (this.facing.axis) {
                default -> throw new IncompatibleClassChangeError();
                case Axis.X -> {
                    if (this.minY != 0.0f || this.maxY != 1.0f || this.minZ != 0.0f || this.maxZ != 1.0f) {
                        yield true;
                    }
                    yield false;
                }
                case Axis.Y -> {
                    if (this.minX != 0.0f || this.maxX != 1.0f || this.minZ != 0.0f || this.maxZ != 1.0f) {
                        yield true;
                    }
                    yield false;
                }
                case Axis.Z -> this.minX != 0.0f || this.maxX != 1.0f || this.minY != 0.0f || this.maxY != 1.0f;
            };
        }
    }

    private static class VectorFanSimple
    extends VectorFan {
        public VectorFanSimple(Vec3f[] coords) {
            super(coords);
        }

        @Override
        @Environment(value=EnvType.CLIENT)
        public void generate(RenderInformationHolder holder, List<class_777> quads) {
            int index;
            for (index = 0; index < this.coords.length - 3; index += 2) {
                this.generate(holder, this.coords[0], this.coords[index + 1], this.coords[index + 2], this.coords[index + 3], quads);
            }
            if (index < this.coords.length - 2) {
                this.generate(holder, this.coords[0], this.coords[index + 1], this.coords[index + 2], this.coords[index + 2], quads);
            }
        }

        @Override
        protected boolean doMinMaxLate() {
            return true;
        }
    }
}

